﻿var distributionWizard = {
    wizardUrls: ["", "EmailDistributionWizard", "PopUpDistributionWizard", "TwitterAuthorization", "SMSDistributionWizard", "Index"],
    initialize: function () {
        $(".v-distribution-wizard").on("change", ".h-distribution-mode", function () {
            if ($(this).val() == 6) {
                $(".url-container").removeClass("disabled");
                $(".url-container input").prop("disabled", false);
            }
            else {
                $(".url-container").addClass("disabled");
                $(".url-container input").prop("disabled", true);
            }
        });

        $(".v-distribution-wizard").on("click", ".h-next-button", function () {
            var context = $(this).closest(".wizard");
            var distributionType = $(".h-distribution-mode:checked", context).val();

            window.location = a4.getSurveyAction(distributionWizard.wizardUrls[distributionType], "Distribute");
        });
    },
    initializeBase: function (wizard) {
        var context = wizard.context;
        var firstPage = $(".page:visible", context);
        var currentPage = firstPage;

        var currentPageIndex = $("#CurrentPage", context).val();

        if (currentPageIndex > 0) {
            currentPage = $(".page[data-index=" + currentPageIndex + "]", context);
            this.togglePages(firstPage, currentPage);
        }

        var pageWithErrors = $(".page:has(.input-validation-error)", context).first();

        if (pageWithErrors.length > 0) {
            this.togglePages(currentPage, pageWithErrors);
        }

        this.setDatePickers();
        this.setAutoNumerics();
    },
    bindBaseEvents: function (wizard) {
        var self = this;
        var context = wizard.context;

        if (context) {
            context.on("click", ".h-next-button", function () {
                if ($(this).attr("disabled") == undefined && a4.validateRequiredFields(context)) {
                    var currentPage = $(".page:visible", context);
                    var nextPage = currentPage.next(".page");

                    if (wizard.canJumpToNextPage !== undefined
                        && wizard.canJumpToNextPage(nextPage) == false) {
                            return;
                    }


                    if (nextPage.next(".page").length == 0) {
                        $(this).addClass("hidden");
                    }

                    if (nextPage.next(".page:not(.v-optional)").length == 0) {
                        $(".v-submit-button", context).removeClass("hidden");
                    }

                    $(".h-prev-button", context).removeClass("hidden");

                    self.togglePages(currentPage, nextPage);

                    if (wizard.updatePage !== undefined) {
                        wizard.updatePage(nextPage);
                    }
                }
            });

            context.on("click", ".h-prev-button", function () {
                if ($(this).attr("disabled") == undefined) {
                    var currentPage = $(".page:visible", context);
                    var previousPage = currentPage.prev(".page");

                    if (previousPage.prev(".page").length == 0) {
                        $(this).addClass("hidden");
                    }

                    $(".h-next-button", context).removeClass("hidden");

                    if (!currentPage.hasClass("v-optional")) {
                        $(".v-submit-button", context).addClass("hidden");
                    }

                    self.togglePages(currentPage, previousPage);
                }
            });

            $(".breadcrumb").on("click", "li:not(.non-clickable)", function () {
                if (a4.validateRequiredFields(context)) {
                    var pageIndex = $(this).attr("data-index");
                    var page = $(".wizard .page[data-index=" + pageIndex + "]");

                    $(".breadcrumb li.current").removeClass("current");
                    $(this).addClass("current");

                    $(".h-prev-button").toggleClass("hidden", page.prev(".page").length == 0);
                    $(".h-next-button").toggleClass("hidden", page.next(".page").length == 0);
                    $(".v-submit-button").toggleClass("hidden", page.next(".page:not(.v-optional)").length > 0);

                    $(".wizard .page:visible").hide();
                    page.show();

                    if (wizard.updatePage !== undefined) {
                        wizard.updatePage(page);
                    }
                }
            });
            $(".v-batchConfigs").on("change", function () {
                if (a4.validateRequiredFields(context)) {
                    $(".v-submit-button").removeClass("hidden");
                } else {
                    $(".v-submit-button").addClass("hidden");
                }
            });
        }
    },
    togglePages: function (hidePage, showPage) {
        hidePage.hide()
        showPage.show();

        var pageIndex = showPage.attr("data-index");
        $(".breadcrumb li.current").removeClass("current");
        $(".breadcrumb li[data-index=" + pageIndex + "]").addClass("current");

        $(".h-prev-button").toggleClass("hidden", showPage.prev(".page").length == 0);
        $(".h-next-button").toggleClass("hidden", showPage.next(".page").length == 0);
        $(".v-submit-button").toggleClass("hidden", showPage.next(".page:not(.v-optional)").length > 0);
    },
    setDatePickers: function () {
        $(".datetime").datetimepicker();
    },
    setAutoNumerics: function () {
        $(".numeric").autoNumeric({ aSep: '', aDec: '.', aPad: false });
    }
}

$(document).ready(function () {
    distributionWizard.initialize();
});

function SetRespondentFilter(filter) {
    $("#RespondentFilter").val(JSON.stringify(filter.Definition));
    $("#RespondentFilterCount").val(filter.Count);
    $("#RespondentFilterSummary").val(filter.Summary);
    $(".v-sampleDetails").html(filter.Summary);
    $("span.field-validation-error[data-valmsg-for='RespondentFilter']").addClass("field-validation-valid").removeClass("field-validation-error").text("");
}